package furny.swing.admin.genotype;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import furny.util.LoggerUtil;

/**
 * This starts the {@link GenotypeFrame}.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public final class GenotypeTool {

  /**
   * Instantiation is not required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private GenotypeTool() {
  }

  /**
   * Main method that starts the {@link GenotypeFrame}.
   * 
   * @param args
   *          No arguments required.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void main(final String[] args) {
    start();
  }

  /**
   * Method that starts the {@link GenotypeFrame}.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public static void start() {
    LoggerUtil.installLogger();

    SwingUtilities.invokeLater(new Runnable() {
      @Override
      public void run() {
        // try {
        // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        // } catch (final Exception e) {
        // LOGGER.log(Level.WARNING, "An error occured", e);
        // }

        final JFrame frame = new GenotypeFrame();
        frame.setVisible(true);
      }
    });
  }
}
